DROP TABLE IF EXISTS channel;
CREATE TABLE channel (
       id INT NOT NULL AUTO_INCREMENT,
       created DATETIME NOT NULL,
       used DATETIME NOT NULL,
       topic VARCHAR(500) NOT NULL,
       is_private TINYINT NOT NULL DEFAULT 0,
       is_moderated TINYINT NOT NULL DEFAULT 0,
       is_topiclock TINYINT NOT NULL DEFAULT 0,
       is_norecap TINYINT NOT NULL DEFAULT 0,
       is_memberrecap TINYINT NOT NULL DEFAULT 0,
       is_joinrecap TINYINT NOT NULL DEFAULT 0,
       is_adhoc TINYINT NOT NULL DEFAULT 0,
       is_solo TINYINT NOT NULL DEFAULT 0,
       is_newsboyoff TINYINT NOT NULL DEFAULT 0,
       is_extendedrecap TINYINT NOT NULL DEFAULT 0,
       recap_count INT NOT NULL,   # automatically calculated

       PRIMARY KEY (id),
       INDEX created_index (created),
       INDEX used_index (used)
);

DROP TABLE IF EXISTS channel_name;
CREATE TABLE channel_name (
       channel_id INT NOT NULL,     # foreign key from channels
       name VARCHAR(100) NOT NULL,
       category_id INT NOT NULL,    # foreign key from categories
       is_primary TINYINT NOT NULL,
       full_name VARCHAR(100) NOT NULL, # automatically calculated

       INDEX id_index (channel_id),
       INDEX category_index (category_id),
       UNIQUE INDEX name_index (name)
);

DROP TABLE IF EXISTS category;
CREATE TABLE category (
       id INT NOT NULL AUTO_INCREMENT,
       parent_id INT NOT NULL,         # id of parent category
       name VARCHAR(50) NOT NULL,
       full_name VARCHAR(100) NOT NULL, # automatically calculated

       PRIMARY KEY (id),
       INDEX parent_index (parent_id),
       INDEX name_index (name),
       UNIQUE INDEX full_name_index (full_name)
);

DROP TABLE IF EXISTS channel_user;
CREATE TABLE channel_user (
       channel_id INT NOT NULL,     # foreign key from channels
       user_id INT NOT NULL,        # (eventually) foreign key from users
       membership TINYINT NOT NULL,

       PRIMARY KEY (channel_id, user_id),
       INDEX channel_index (channel_id),
       INDEX user_index (user_id)
);

DROP TABLE IF EXISTS channel_recap;
CREATE TABLE channel_recap (
       id INT NOT NULL AUTO_INCREMENT,
       channel_id INT NOT NULL,     # foreign key from channels
       user_id INT NOT NULL,        # (eventually) foreign key from users
       time DATETIME NOT NULL,
       text TEXT NOT NULL,

       PRIMARY KEY (id),
       INDEX channel_index (channel_id),
       INDEX user_index (user_id),
       INDEX time_index (time)
);

# This should probably have identical columns to the mail table
DROP TABLE IF EXISTS bb;
CREATE TABLE bb (
       id INT NOT NULL AUTO_INCREMENT,
       board_id INT NOT NULL,      # foreign key from channels
       author_id INT NOT NULL,     # (eventually) foreign key from users
       time DATETIME NOT NULL,
       msg_index INT NOT NULL,
       subject VARCHAR(150) NOT NULL,
       body TEXT NOT NULL,
       is_deleted TINYINT NOT NULL,
       active TINYINT NOT NULL,

       PRIMARY KEY (id),
       INDEX board_index (board_id),
       INDEX author_index (author_id),
       INDEX time_index (time)
);

DROP TABLE IF EXISTS bb_read;
CREATE TABLE bb_read (
       user_id INT NOT NULL,       # (eventually) foreign key from users
       board_id INT NOT NULL,      # foreign key from channels
       time DATETIME NOT NULL,

       INDEX user_index (user_id),
       INDEX board_index (board_id),
       INDEX time_index (time)
);

# This should probably have identical columns to the bb table
DROP TABLE IF EXISTS mail;
CREATE TABLE mail (
       id INT NOT NULL AUTO_INCREMENT,
       board_id INT NOT NULL,      # (eventually) foreign key from users
       author_id INT NOT NULL,     # (eventually) foreign key from users
       time DATETIME NOT NULL,
       msg_index INT NOT NULL,
       subject VARCHAR(150) NOT NULL,
       body TEXT NOT NULL,
       is_deleted TINYINT NOT NULL,
       active TINYINT NOT NULL,

       PRIMARY KEY (id),
       INDEX board_index (board_id),
       INDEX author_index (author_id),
       INDEX time_index (time)
);

DROP TABLE IF EXISTS mail_read;
CREATE TABLE mail_read (
       user_id INT NOT NULL,       # (eventually) foreign key from users
       board_id INT NOT NULL,      # foreign key from channels
       time DATETIME NOT NULL,

       INDEX user_index (user_id),
       INDEX board_index (board_id),
       INDEX time_index (time)
);

DROP TABLE IF EXISTS quotation;
CREATE TABLE quotation (
       id INT NOT NULL AUTO_INCREMENT,
       quoter_id INT NOT NULL,     # (eventually) foreign key from users
       quotee_id INT NOT NULL,     # (eventually) foreign key from users
       time DATETIME NOT NULL,
       text TEXT NOT NULL,

       PRIMARY KEY (id),
       INDEX quoter_index (quoter_id),
       INDEX quotee_index (quotee_id),
       INDEX time_index (time)
);
